<?php
if ( ! defined( 'ABSPATH' ) ) exit;

function rank_get_api_key() {
    return get_option( 'rank_api_key', '' );
}

// Define health check categories recognized by the plugin
function rank_get_health_check_categories() {
    return array(
        'missing_meta_description' => 'Missing Meta Description',
        'short_meta_description'   => 'Short Meta Description',
        'long_meta_description'    => 'Long Meta Description',
        'missing_title_tag'        => 'Missing Title Tag',
        'short_title_tag'          => 'Short Title Tag',
        'long_title_tag'           => 'Long Title Tag',
        'missing_alt_tags'         => 'Missing Alt Tag',
        'broken_links_external'    => 'Broken External Link',
        'broken_links_internal'    => 'Broken Internal Link',
        // Add more categories as needed, matching API expectations
    );
}

// Map issue types to their processing requirements and display information
function rank_get_issue_type_config($issue_type = null) {
    $configs = array(
        'missing_meta_description' => array(
            'label' => 'Missing Meta Descriptions',
            'display_text' => 'Missing meta description',
            'content_type' => 'text',
            'solution_label' => 'Meta Description',
            'identifier_is_url' => false,
            'handler_type' => 'database_override',
        ),
        'short_meta_description' => array(
            'label' => 'Short Meta Descriptions',
            'display_text' => 'Meta description too short',
            'content_type' => 'text',
            'solution_label' => 'Suggested Meta Description',
            'identifier_is_url' => false,
            'handler_type' => 'database_override',
        ),
        'long_meta_description' => array(
            'label' => 'Long Meta Descriptions',
            'display_text' => 'Meta description too long',
            'content_type' => 'text',
            'solution_label' => 'Suggested Meta Description',
            'identifier_is_url' => false,
            'handler_type' => 'database_override',
        ),
        'missing_title_tag' => array(
            'label' => 'Missing Title Tags',
            'display_text' => 'Missing title tag',
            'content_type' => 'text',
            'solution_label' => 'Title',
            'identifier_is_url' => false,
            'handler_type' => 'database_override',
        ),
        'short_title_tag' => array(
            'label' => 'Short Title Tags',
            'display_text' => 'Title tag too short',
            'content_type' => 'text',
            'solution_label' => 'Suggested Title',
            'identifier_is_url' => false,
            'handler_type' => 'database_override',
        ),
        'long_title_tag' => array(
            'label' => 'Long Title Tags',
            'display_text' => 'Title tag too long',
            'content_type' => 'text',
            'solution_label' => 'Suggested Title',
            'identifier_is_url' => false,
            'handler_type' => 'database_override',
        ),
        'missing_alt_tags' => array(
            'label' => 'Missing Alt Tags',
            'display_text' => 'Missing alt text',
            'content_type' => 'text',
            'solution_label' => 'Alt Text',
            'identifier_is_url' => true,
            'handler_type' => 'database_override',
        ),
        'broken_links_external' => array(
            'label' => 'Broken External Links',
            'display_text' => 'Broken external link',
            'content_type' => 'url',
            'solution_label' => 'Suggested Fixed URL',
            'identifier_is_url' => true,
            'handler_type' => 'option_suggestion',
        ),
        'broken_links_internal' => array(
            'label' => 'Broken Internal Links',
            'display_text' => 'Broken internal link',
            'content_type' => 'url',
            'solution_label' => 'Suggested Fixed URL',
            'identifier_is_url' => true,
            'handler_type' => 'option_suggestion',
        ),
    );
    
    if ($issue_type !== null) {
        return isset($configs[$issue_type]) ? $configs[$issue_type] : null;
    }
    
    return $configs;
}